% nvbgNX
% 2022/11/09 Yokokura, Yuki
classdef TimeSeriesPlot < handle
properties(Constant)

end
properties(SetAccess = protected)
	FigHandle;
	FigLeft    = 100;				% [px] figure̍W
	FigBottom  = 50;				% [px] figurẻW
	FigWidth   = 1000;				% [px] figure̕
	FigHeight  = 700;				% [px] figure̍
	FontSize   = 14;				% [pt] TCY
	FontName   = 'Times New Roman';	% tHg
	NumPlanes  = 2;					% vbgʂ̒i
	Left       = 0.1;				% vbgʂ̍ʒu
	Width      = 0.88;				% vbgʂ̉
	Height     = 0.88/2;			% vbgʂ̍
	Interval   = 0.02/2;			% vbgʂ̊Ԋu 
	Margin     = 0.09;				% vbgʂ̍ŉi̗]
	AxisColor  = [0,0,0];			% ̐F
	BackColor  = [1,1,1];			% wiF
	Line1Color = [0,0,0];			% vbg1̐F(n)
	Line2Color = [225/255,40/255,133/255];	% vbg2̐F(Ԍn)
	Line3Color = [134/255,206/255,203/255];	% vbg3̐F(n)
	Line1Width = 1.6;				% vbg1̑
	Line2Width = 2.6;				% vbg2̑
	Line3Width = 3.6;				% vbg3̑
	RedRate    = 1;					% f[^Ԉ(_ETvO)
	TimeName   = 'Time [s]';		% Ԏ̃x
	TimeData;						% f[^
	Tmin = 0;						% [s] Ԕ͈͂̍ŏl
	Tstp = 1;						% [s] Ԃ̊Ԋu
	Tmax = 10;						% [s] Ԕ͈͂̍ől
	CurrentPlane = 0;				% ݍƒ̃vbg
end
methods(Static)
	
end
methods
	% RXgN^
	function this = TimeSeriesPlot(Handle)
		this.FigHandle = Handle;
		clf(this.FigHandle);
		set(this.FigHandle, 'PaperPositionMode','auto');
		set(this.FigHandle, 'Position',[this.FigLeft, this.FigBottom, this.FigWidth, this.FigHeight]);
		set(this.FigHandle, 'Color',this.BackColor);
	end
	
	% Otʒu̐ݒ֐
	function FigurePosition(this, Left, Bottom)
		this.FigLeft = Left;
		this.FigBottom = Bottom;
		set(this.FigHandle, 'Position', [this.FigLeft, this.FigBottom, this.FigWidth, this.FigHeight]);
	end
	
	% OtTCY̐ݒ֐
	function FigureSize(this, Width, Height)
		this.FigWidth = Width;
		this.FigHeight = Height;
		set(this.FigHandle, 'Position', [this.FigLeft, this.FigBottom, this.FigWidth, this.FigHeight]);
	end
	
	% vbgʂ̒i̐ݒ֐
	function NumOfPlanes(this, Planes)
		this.NumPlanes = Planes;
		this.Height = 0.88/this.NumPlanes;		% vbgʂ̍
		this.Interval = 0.02/this.NumPlanes;	% vbgʂ̊Ԋu
		% 1ił̂Ƃ͓ݒ
		if this.NumPlanes == 1
			this.Height = 0.8;
			this.Margin = 0.17;
		end
	end
	
	% f[^_ETvOĊԈ֐
	function DataOut = DownSampling(this, DataIn)
		len = length(DataIn(:,1));
		DataOut = DataIn(1:this.RedRate:len, :);
	end
	
	% f[^팸߂̊Ԉݒ֐
	function ReductionRate(this, ReductionNum)
		this.RedRate = ReductionNum;
	end
	
	% f[^̓ǂݍ
	function LoadTimeData(this, Time)
		this.TimeData = this.DownSampling(Time);
	end
	
	% ͈͂̐ݒ֐
	function TimeRange(this, Tmin, Tstp, Tmax)
		this.Tmin = Tmin;
		this.Tstp = Tstp;
		this.Tmax = Tmax;
	end
	
	% Ԏ̃x̐ݒ֐
	function TimeLabel(this, TName)
		this.TimeName = TName;
	end
	
	% vbgʂ̈ʒuƃTCY̐ݒ֐
	function Ax = PlaneLocationAndSize(this, Current)
		CurrentBottom = (this.NumPlanes - Current)*(this.Height + this.Interval) + this.Margin;	% W̌vZ
		Pos = [this.Left, CurrentBottom, this.Width, this.Height];								% [, , , ] 
		Ax = axes('Position', Pos);
	end
	
	% vbg֐(1ϐ)
	function LinePlot1(this, Y)
		this.CurrentPlane = this.CurrentPlane + 1;
		Ax = this.PlaneLocationAndSize(this.CurrentPlane);
		h = plot(Ax, this.TimeData, this.DownSampling(Y));
		set(h, 'LineWidth',this.Line1Width, 'Color',this.Line1Color);
		this.AutoGrid(Ax);
	end
	
	% vbg֐(2ϐ)
	function LinePlot2(this, Y1, Y2)
		this.CurrentPlane = this.CurrentPlane + 1;
		Ax = this.PlaneLocationAndSize(this.CurrentPlane);
		h = plot(Ax, this.TimeData, this.DownSampling(Y1));
		set(h, 'LineWidth',this.Line2Width, 'Color',this.Line2Color);
		hold on;
		h = plot(Ax, this.TimeData, this.DownSampling(Y2));
		set(h, 'LineWidth',this.Line1Width, 'Color',this.Line1Color);
		hold off;
		this.AutoGrid(Ax);
	end
	
	% vbg֐(3ϐ)
	function LinePlot3(this, Y1, Y2, Y3)
		this.CurrentPlane = this.CurrentPlane + 1;
		Ax = this.PlaneLocationAndSize(this.CurrentPlane);
		h = plot(Ax, this.TimeData, this.DownSampling(Y1));
		set(h, 'LineWidth',this.Line3Width, 'Color',this.Line3Color);
		hold on;
		h = plot(Ax, this.TimeData, this.DownSampling(Y2));
		set(h, 'LineWidth',this.Line2Width, 'Color',this.Line2Color);
		h = plot(Ax, this.TimeData, this.DownSampling(Y3));
		set(h, 'LineWidth',this.Line1Width, 'Color',this.Line1Color);
		hold off;
		this.AutoGrid(Ax);
	end
	
	% Kivbg֐(1ϐ)
	function StairsPlot1(this, Y)
		this.CurrentPlane = this.CurrentPlane + 1;
		Ax = this.PlaneLocationAndSize(this.CurrentPlane);
		h = stairs(Ax, this.TimeData, this.DownSampling(Y));
		set(h, 'LineWidth',this.Line1Width, 'Color',this.Line1Color);
		this.AutoGrid(Ax);
	end
	
	% Kivbg֐(2ϐ)
	function StairsPlot2(this, Y1, Y2)
		this.CurrentPlane = this.CurrentPlane + 1;
		Ax = this.PlaneLocationAndSize(this.CurrentPlane);
		h = stairs(Ax, this.TimeData, this.DownSampling(Y1));
		set(h, 'LineWidth',this.Line2Width, 'Color',this.Line2Color);
		hold on;
		h = stairs(Ax, this.TimeData, this.DownSampling(Y2));
		set(h, 'LineWidth',this.Line1Width, 'Color',this.Line1Color);
		hold off;
		this.AutoGrid(Ax);
	end
	
	% Kivbg֐(3ϐ)
	function StairsPlot3(this, Y1, Y2, Y3)
		this.CurrentPlane = this.CurrentPlane + 1;
		Ax = this.PlaneLocationAndSize(this.CurrentPlane);
		h = stairs(Ax, this.TimeData, this.DownSampling(Y1));
		set(h, 'LineWidth',this.Line3Width, 'Color',this.Line3Color);
		hold on;
		h = stairs(Ax, this.TimeData, this.DownSampling(Y2));
		set(h, 'LineWidth',this.Line2Width, 'Color',this.Line2Color);
		h = stairs(Ax, this.TimeData, this.DownSampling(Y3));
		set(h, 'LineWidth',this.Line1Width, 'Color',this.Line1Color);
		hold off;
		this.AutoGrid(Ax);
	end
	
	% cx̐ݒ֐
	function AxisLabel(this, Name)
		this.Label(this.CurrentPlane, Name);
	end
	
	% Obhݒ肷֐
	function AutoGrid(this, Ax)
		Ymax = max(Ax.YTick);
		Ymin = min(Ax.YTick);
		Ystp = (Ymax - Ymin)/(length(Ax.YTick) - 1);
		Xmax = max(Ax.XTick);
		Xmin = min(Ax.XTick);
		Xstp = (Xmax - Xmin)/(length(Ax.XTick) - 1);
		this.FullManualGrid(Xmin, Xstp, Xmax, Ymin, Ystp, Ymax);
		Ax.YAxis.Exponent = 0;
	end
	
	% Obh蓮ݒ肷֐
	function ManualGrid(this, Ymin, Ystp, Ymax)
		grid on;
		axis([this.Tmin, this.Tmax, Ymin - Ystp/2, Ymax + Ystp/2]);
		set(gca,'XTickMode','manual','YTickMode','manual','XTick', this.Tmin:this.Tstp:this.Tmax,'YTick', Ymin:Ystp:Ymax);
	end
	
	% ObhS蓮ݒ肷֐
	function FullManualGrid(this, Xmin, Xstp, Xmax, Ymin, Ystp, Ymax)
		grid on;
		axis([Xmin, Xmax, Ymin - Ystp/2, Ymax + Ystp/2]);
		set(gca,'XTickMode','manual','YTickMode','manual','XTick', Xmin:Xstp:Xmax,'YTick', Ymin:Ystp:Ymax);
	end
	
	% x̐ݒ֐
	function Label(this, Current, Name)
		if this.NumPlanes ~= Current
			set(gca,'XTickLabel',{});	% ŉiȊO͉x
		else
			xlabel(this.TimeName,'FontSize',this.FontSize,'FontName',this.FontName);	% ŉîݎxt
		end
		ylabel(gca, Name, 'FontSize',this.FontSize, 'FontName',this.FontName);
		set(gca, 'FontSize',this.FontSize, 'FontName',this.FontName);
		set(gca, 'Color',this.BackColor, 'XColor',this.AxisColor, 'YColor',this.AxisColor);
	end
	
	% PNG摜EPSt@C
	function SavePNGandEPS(this, FileName)
		EpsFileName = strcat(FileName(1:length(FileName)-4), '.eps');	% gqEPSɕϊ
		PngFileName = strcat(FileName(1:length(FileName)-4), '.png');	% gqPNGɕϊ
		saveas(this.FigHandle, strcat(PngFileName));
		print(this.FigHandle,'-depsc2','-tiff','-painters',strcat(EpsFileName));
	end
	
	% }̐ݒ֐(2ϐ)
	function Legend2(this, Name1, Name2, Position)
		h = legend(Name1, Name2, 'Location',Position, 'Orientation','Vertical');
		set(h, 'TextColor',this.AxisColor);
		set(h, 'FontSize',this.FontSize, 'FontName',this.FontName);
		legend boxoff;
	end
	
	% }̐ݒ֐(3ϐ)
	function Legend3(this, Name1, Name2, Name3, Position)
		h = legend(Name1, Name2, Name3, 'Location',Position, 'Orientation','Vertical');
		set(h, 'TextColor',this.AxisColor);
		set(h, 'FontSize',this.FontSize, 'FontName',this.FontName);
		legend boxoff;
	end
	
end
end

